﻿© Fluke Calibration. All Rights Reserved.                   MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub NI PXI-4130 (1 yr) Ch1 200 µA Meas Test LIB /8508
INSTRUMENT:            Sub NI PXI-4130 (1 yr) Ch1 2 mA Meas Test LIB /8508
INSTRUMENT:            Sub NI PXI-4130 (1 yr) Ch1 20 mA Meas Test LIB /8508
INSTRUMENT:            Sub NI PXI-4130 (1 yr) Ch1 200 mA Meas Test LIB /8508
INSTRUMENT:            Sub NI PXI-4130 (1 yr) Ch1 2 A Meas Test LIB /8508
DATE:                  2011-10-24 09:26:11
AUTHOR:                Fluke
REVISION:              $Revision: 1.2 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       11
NUMBER OF LINES:       237
CONFIGURATION:         Fluke 8508A
=============================================================================
#
#  Text Source:
#    $RCSfile: sub_ni_pxi-4130_1yr_ch1_current_meas_test_lib_8508.txt,v $
#    $Date: 2011/10/24 19:04:32 $
#
#  Procedure Author:
#        DAC
#
#  Model(s) Covered:
#        PXI-4130
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Subprocedures:
#        Sub NI DC Power Setup LIB
#        Sub NI DC Power Error Message LIB
#
#  Required Files:
#        None
#
#  Additional Equipment Required:
#        None
#
#  The copyright for this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         200uA_MEASUREMENT_TEST       PSUBI("200 µA Meas Test")
  1.002  JMPL         2mA_MEASUREMENT_TEST         PSUBI("2 mA Meas Test")
  1.003  JMPL         20mA_MEASUREMENT_TEST        PSUBI("20 mA Meas Test")
  1.004  JMPL         200mA_MEASUREMENT_TEST       PSUBI("200 mA Meas Test")
  1.005  JMPL         2A_MEASUREMENT_TEST          PSUBI("2 A Meas Test")
  1.006  DISP         Subprocedure not found!
  1.007  END

  1.008  EVAL   Increment step number

# =====  Sub NI PXI-4130 (1 yr) Ch1 200 µA Meas Test LIB /8508  =============

  2.001  LABEL        200uA_MEASUREMENT_TEST
  2.002  MATH         CardinalPoint = @niDCPwrCurrLmt / 1E-6

  2.003  IF           @niDCPwrVolt < 0
  2.004  MATH         CardinalPoint = -1.0 * CardinalPoint
  2.005  ENDIF

  2.006  TARGET       -p
  2.007  TSET         CPT = [V CardinalPoint] uA
  2.008  CALL         Sub NI DC Power Setup LIB
  2.009  WAIT         -t 3 Settling...
  2.010  MATH         MEM = CardinalPoint
  2.011  8508         uA                                             D5 N  2W
  2.012  MATH         SystemActual = MEM
  2.013  MATH         @Method = "NI DC Power Measure"
  2.014  TARGET       -m

  2.015  DO
  2.016  LIB          @Status = uut.niDCPower_Measure
  2.016  LIB          (@vi, @niDCPwrChan, @niDCPwrValMeasCurr, MEM);

  2.017  IF           @Status
  2.018  CALL         Sub NI DC Power Error Message LIB
  2.019  ENDIF

  2.020  UNTIL        (@Status == 0)

  2.021  MATH         MEM = MEM / 1E-6; MEM1 = SystemActual
  2.022  MEMCX  200   uA             0.03% 0.02U

  3.001  END

  3.002  EVAL   Increment step number

# =====  Sub NI PXI-4130 (1 yr) Ch1 2 mA Meas Test LIB /8508  ===============

  4.001  LABEL        2mA_MEASUREMENT_TEST
  4.002  MATH         CardinalPoint = @niDCPwrCurrLmt / 1E-3

  4.003  IF           @niDCPwrVolt < 0
  4.004  MATH         CardinalPoint = -1.0 * CardinalPoint
  4.005  ENDIF

  4.006  TARGET       -p
  4.007  TSET         CPT = [V CardinalPoint] mA
  4.008  CALL         Sub NI DC Power Setup LIB
  4.009  WAIT         -t 3 Settling...
  4.010  MATH         MEM = CardinalPoint
  4.011  8508         mA                                             D5 N  2W
  4.012  MATH         SystemActual = MEM
  4.013  MATH         @Method = "NI DC Power Measure"
  4.014  TARGET       -m

  4.015  DO
  4.016  LIB          @Status = uut.niDCPower_Measure
  4.016  LIB          (@vi, @niDCPwrChan, @niDCPwrValMeasCurr, MEM);

  4.017  IF           @Status
  4.018  CALL         Sub NI DC Power Error Message LIB
  4.019  ENDIF

  4.020  UNTIL        (@Status == 0)

  4.021  MATH         MEM = MEM / 1E-3; MEM1 = SystemActual
  4.022  MEMCX  2     mA             0.03% 0.0002U

  5.001  END

  5.002  EVAL   Increment step number

# =====  Sub NI PXI-4130 (1 yr) Ch1 20 mA Meas Test LIB /8508  ==============

  6.001  LABEL        20mA_MEASUREMENT_TEST
  6.002  MATH         CardinalPoint = @niDCPwrCurrLmt / 1E-3

  6.003  IF           @niDCPwrVolt < 0
  6.004  MATH         CardinalPoint = -1.0 * CardinalPoint
  6.005  ELSE
  6.006  ENDIF

  6.007  TARGET       -p
  6.008  TSET         CPT = [V CardinalPoint] mA
  6.009  CALL         Sub NI DC Power Setup LIB
  6.010  WAIT         -t 3 Settling...
  6.011  MATH         MEM = CardinalPoint
  6.012  8508         mA                                             D6 N  2W
  6.013  MATH         SystemActual = MEM
  6.014  MATH         @Method = "NI DC Power Measure"
  6.015  TARGET       -m

  6.016  DO
  6.017  LIB          @Status = uut.niDCPower_Measure
  6.017  LIB          (@vi, @niDCPwrChan, @niDCPwrValMeasCurr, MEM);

  6.018  IF           @Status
  6.019  CALL         Sub NI DC Power Error Message LIB
  6.020  ENDIF

  6.021  UNTIL        (@Status == 0)

  6.022  MATH         MEM = MEM / 1E-3; MEM1 = SystemActual
  6.023  MEMCX  20    mA             0.03% 0.002U

  7.001  END

  7.002  EVAL   Increment step number

# =====  Sub NI PXI-4130 (1 yr) Ch1 200 mA Meas Test LIB /8508  =============

  8.001  LABEL        200mA_MEASUREMENT_TEST
  8.002  MATH         CardinalPoint = @niDCPwrCurrLmt / 1E-3

  8.003  IF           @niDCPwrVolt < 0
  8.004  MATH         CardinalPoint = -1.0 * CardinalPoint
  8.005  ELSE
  8.006  ENDIF

  8.007  TARGET       -p
  8.008  TSET         CPT = [V CardinalPoint] mA
  8.009  CALL         Sub NI DC Power Setup LIB
  8.010  WAIT         -t 3 Settling...
  8.011  MATH         MEM = CardinalPoint
  8.012  8508         mA                                             D6 N  2W
  8.013  MATH         SystemActual = MEM
  8.014  MATH         @Method = "NI DC Power Measure"
  8.015  TARGET       -m

  8.016  DO
  8.017  LIB          @Status = uut.niDCPower_Measure
  8.017  LIB          (@vi, @niDCPwrChan, @niDCPwrValMeasCurr, MEM);

  8.018  IF           @Status
  8.019  CALL         Sub NI DC Power Error Message LIB
  8.020  ENDIF

  8.021  UNTIL        (@Status == 0)

  8.022  MATH         MEM = MEM / 1E-3; MEM1 = SystemActual
  8.023  MEMCX  200   mA             0.03% 0.04U

  9.001  END

  9.002  EVAL   Increment step number

# =====  Sub NI PXI-4130 (1 yr) Ch1 2 A Meas Test LIB /8508  ================

 10.001  LABEL        2A_MEASUREMENT_TEST
 10.002  HEAD         CURRENT MEASUREMENT ACCURACY: Channel 1
 10.003  MATH         CardinalPoint = @niDCPwrCurrLmt

 10.004  IF           @niDCPwrVolt < 0
 10.005  MATH         CardinalPoint = -1.0 * CardinalPoint
 10.006  ENDIF

# For current >=500 mA, refer to the additional derating information in Figure
# 4, "Accuracy Derating versus Load Current".
 10.007  MATH         L[1] = @AdditionalDerating
 10.008  TOL          0.12% 0.0002U L1%
 10.009  TARGET       -p
 10.010  TSET         CPT = [V CardinalPoint] A
 10.011  CALL         Sub NI DC Power Setup LIB
 10.012  WAIT         -t 3 Settling...
 10.013  MATH         MEM = CardinalPoint
 10.014  8508         A                                              D7 N  2W
 10.015  MATH         SystemActual = MEM
 10.016  MATH         @Method = "NI DC Power Measure"
 10.017  TARGET       -m

 10.018  DO
 10.019  LIB          @Status = uut.niDCPower_Measure
 10.019  LIB          (@vi, @niDCPwrChan, @niDCPwrValMeasCurr, MEM);

 10.020  IF           @Status
 10.021  CALL         Sub NI DC Power Error Message LIB
 10.022  ENDIF

 10.023  UNTIL        (@Status == 0)

 10.024  MATH         MEM1 = SystemActual
 10.025  MEMCX  2     A              TOL

 11.001  END
